﻿using Microsoft.Practices.Prism.Modularity;
using Microsoft.Practices.Prism.UnityExtensions;
using System.Windows;

using Microsoft.Practices.Unity;
using Microsoft.Practices.Prism.Logging;
using Microsoft.Practices.ServiceLocation;
using Microsoft.Practices.Prism.Regions;
using System.Windows.Controls;

namespace Shell
{
    public class Bootstrapper : UnityBootstrapper
    {
        protected override DependencyObject CreateShell()
        {
            return new ShellWindow();
        }

        protected override void InitializeShell()
        {
            this.Container.RegisterInstance<IRegionNavigationContentLoader>(new ViewModelContentLoader(this.Container.Resolve<IServiceLocator>()));

            base.InitializeShell();

            App.Current.MainWindow = (Window)this.Shell;
            App.Current.MainWindow.Show();

            var logger = (SimpleLogger)ServiceLocator.Current.GetInstance(typeof(ILoggerFacade));
            logger.Log("Inicjalizacja aplikacji zakończona", Category.Info, Priority.None);
        }


        protected override Microsoft.Practices.Prism.Logging.ILoggerFacade CreateLogger()
        {
            return new SimpleLogger();
        }

        protected override void ConfigureModuleCatalog()
        {

            base.ConfigureModuleCatalog();

            ModuleCatalog moduleCatalog = (ModuleCatalog)this.ModuleCatalog;

            moduleCatalog.AddModule(typeof(ModuleA.ModuleA), InitializationMode.WhenAvailable);
            moduleCatalog.AddModule(typeof(ModuleB.ModuleB), InitializationMode.WhenAvailable);
        }

        protected override RegionAdapterMappings ConfigureRegionAdapterMappings()
        {
            RegionAdapterMappings mappings = base.ConfigureRegionAdapterMappings();
            mappings.RegisterMapping(typeof(StackPanel), Container.Resolve<StackPanelRegionAdapter>());

            return mappings;
        }

    }
}
